#version 330
#extension GL_EXT_gpu_shader4 : enable
//Fusion Generator AMod01.fsh  by   JupiterDude
//https://www.shadertoy.com/view/fty3zh
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.1415926535897932384626433832795
#define PI2 6.283185307179586476925286766559
#define PI4 12.566370614359172953850573533118

#define OCTAVES 6
#define SPEEDX (0.05)
#define SPEEDY (SPEEDX * .4)
#define RSCALE 2.4
#define GSCALE 2.8
#define BSCALE 2.1

vec2 random(vec2 uv){
    uv = vec2( dot(uv, vec2(123.7, 31.9) ),
               dot(uv, vec2(609.2, 183.71) ) );
    return -1.0 + 2.0 * fract( sin(uv) * 343803.23346);
}

float noise(vec2 uv, float scale) {
    uv *= scale;
    uv = abs(uv);
    vec2 index = floor(uv);
    vec2 fraction = fract(uv);
    vec2 blend = smoothstep(0.0, 1.0, fraction);
    return mix(
        mix(
            dot( random(index + vec2( 0.0, 0.0 ) ), fraction - vec2( 0.0, 0.0 ) ),
            dot( random(index + vec2( 1.0, 0.0 ) ), fraction - vec2( 1.0, 0.0 ) ),
            blend.x),
        mix(
            dot( random(index + vec2( 0.0, 1.0 ) ), fraction - vec2( 0.0, 1.0 ) ),
            dot( random(index + vec2( 1.0, 1.0 ) ), fraction - vec2( 1.0, 1.0 ) ),
            blend.x),
        blend.y) * 0.5 + 0.5;
}

float noiseX(vec2 tuv, vec2 uv, float scale) {
    // vec2 tuv = abs(uv);
    uv *= scale;
    uv = abs(uv);
    vec2 index = floor(uv);
    vec2 fraction = fract(uv);
    vec2 blend = smoothstep(0.0, 1.0, fraction);
    
    if (tuv.x > (iMouse.x / iResolution.x)-.5) {
        return mix(
            mix(
                dot( random(index + vec2( 0.0, 0.0 ) ), fraction - vec2( 1.0, 0.0 ) ),
                dot( random(index + vec2( 1.0, 0.0 ) ), fraction - vec2( 1.0, 0.0 ) ),
                blend.x),
            mix(
                dot( random(index + vec2( 0.0, 1.0 ) ), fraction - vec2( 0.0, 1.0 ) ),
                dot( random(index + vec2( 1.0, 1.0 ) ), fraction - vec2( 1.0, 1.0 ) ),
                blend.x),
            blend.y) * 0.5 + 0.5;
     } else {
        return mix(
            mix(
                dot( random(index + vec2( 0.0, 0.0 ) ), fraction - vec2( 0.0, 0.0 ) ),
                dot( random(index + vec2( 1.0, 0.0 ) ), fraction - vec2( 1.0, 0.0 ) ),
                blend.x),
            mix(
                dot( random(index + vec2( 0.0, 1.0 ) ), fraction - vec2( 0.0, 1.0 ) ),
                dot( random(index + vec2( 1.0, 1.0 ) ), fraction - vec2( 1.0, 1.0 ) ),
                blend.x),
            blend.y) * 0.5 + 0.5;
     }
}

float bnoise(vec2 c, float scale) {
    float t = 0.0;
    vec2 tc = c;
    c = abs(c);
    float octave = .7;
    float r0 = (12.0 + iTime * SPEEDX) * -sign(c.x);
    float r1 = (13.0 + iTime * SPEEDY) * -sign(c.y);
    float ot = noise(c + 12.0, 2.0);
    for( int a=0; a<OCTAVES; a++ ){
        c.x += r0;
        c.y += r1;
        float n = noiseX(tc, c + ot, scale) * octave;
        ot = n;
        octave /= 2.0;
        scale *= 2.0;
        t += n; // t = max(t, n);
    }
    return t;
}

float color(float t) {
    return pow(cos((1.0-t)*PI)*.5 + .5, 3.0);
}
void main (void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = gl_FragCoord.xy/iResolution.xy;
    float aspect = iResolution.x / iResolution.y;
    vec2 c = uv - .5;
    uv.x *= aspect;
    float r = bnoise(c, RSCALE);
    float g = bnoise(c, GSCALE);
    float b = bnoise(c, BSCALE);
    r = color(r);
    g = color(g);
    b = color(b);
    float rr = (r+g) / 2.0;
    float gg = (g+b) / 2.0;
    float bb = (b+r) / 2.0;
    gl_FragColor = vec4(rr, gg, bb, 1.0);
}



